/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CString.h,v 1.5 1999/12/12 07:08:56 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CString_h	// [
#define Included_CString_h

#include "pgpClassesConfig.h"
#include "CArray.h"

_PGP_BEGIN

// Class CString

class CString SMART_ERROR_INHERIT
{

public:
	enum
	{
		kDefaultStringSize	= 128, 
		kBigStringSize		= 1024, 
		kMaxFormatStrSize	= 512
	};

	CString();
	CString(const CString& cstr);
	explicit CString(const char *str);
	explicit CString(char c);
	~CString() { }

	CString&	operator=(const CString& cstr);
	CString&	operator=(const char *str);
	CString&	operator=(char c);

	CString&	operator+=(const char *str);
	CString&	operator+=(char c);

	PGPBoolean	operator==(const char *str) const {return Compare(str);}
	PGPBoolean	operator!=(const char *str) const {return !Compare(str);}

	operator const char *() const {return mCharArray.Get();}

	const char *	Get() const {return mCharArray.Get();}

	char		LastChar() const {return GetAt(Length() - 1);}
	PGPUInt32	Length() const;
	PGPBoolean	Compare(const char *str) const;
	PGPBoolean	CompareNoCase(const char *str) const;
	PGPBoolean	IsEmpty() const {return (GetAt(0) == '\0');}

	PGPInt32	Find(char c, PGPUInt32 nth = 1) const;
	PGPInt32	Find(const char *str, PGPUInt32 nth = 1) const;

	PGPInt32	ReverseFind(char c, PGPUInt32 nth = 1) const;

	char	GetAt(PGPUInt32 pos) const {return mCharArray[pos];}
	void	SetAt(PGPUInt32 pos, char c) {mCharArray[pos] = c;}

	SMART_ERROR	Left(PGPUInt32 i, CString& cstr) const;
	SMART_ERROR	Mid(PGPUInt32 i, PGPUInt32 j, CString& cstr) const;
	SMART_ERROR	Right(PGPUInt32 i, CString& cstr) const;

#if PGP_EXCEPTIONS
	char *		GetBuffer(PGPUInt32 bufSize);
#else	// !PGP_EXCEPTIONS
	CComboError	GetBuffer(PGPUInt32 bufSize, char *& buf);
#endif	// PGP_EXCEPTIONS

	void	ReleaseBuffer();
	void	Empty();

	SMART_ERROR	Assign(const char *str);
	SMART_ERROR	Assign(char c);
	SMART_ERROR	Append(const char *str);
	SMART_ERROR	Append(char c);
	SMART_ERROR	Prepend(const char *str);
	SMART_ERROR	Prepend(char c);

	void	Uppercase();
	void	Lowercase();

	SMART_ERROR	Format(const char *formatStr, ...);
	SMART_ERROR	Resize(PGPUInt32 newSize);

private:
	CArray<char>	mCharArray;
	
	void	Init();
};

_PGP_END

#endif	// ] Included_CString_h
